import { json } from '@sveltejs/kit';
import { db } from '$lib/server/db.js';

/** @type {import('./$types').RequestHandler} */
export async function GET({ params }) {
  try {
    const id = parseInt(params.id);
    const [subjects] = await db.query('SELECT * FROM subjects WHERE id = ?', [id]);
    
    if (subjects.length === 0) {
      return json({ error: 'Mata pelajaran tidak ditemukan' }, { status: 404 });
    }
    
    return json({ success: true, data: subjects[0] });
  } catch (error) {
    console.error('Get subject error:', error);
    return json({ error: 'Gagal mengambil data mata pelajaran' }, { status: 500 });
  }
}

/** @type {import('./$types').RequestHandler} */
export async function PUT({ params, request }) {
  try {
    const id = parseInt(params.id);
    const data = await request.json();
    const { name, type, major, description } = data;

    if (!name) {
      return json({ error: 'Nama mata pelajaran wajib diisi' }, { status: 400 });
    }

    await db.query(
      `UPDATE subjects 
       SET name = ?, type = ?, major = ?, description = ?
       WHERE id = ?`,
      [name.trim(), type || 'core', major || null, description || null, id]
    );

    return json({ success: true, message: 'Mata pelajaran berhasil diupdate' });
  } catch (error) {
    console.error('Update subject error:', error);
    return json({ error: 'Gagal mengupdate mata pelajaran' }, { status: 500 });
  }
}

/** @type {import('./$types').RequestHandler} */
export async function DELETE({ params }) {
  try {
    const id = parseInt(params.id);
    await db.query('DELETE FROM subjects WHERE id = ?', [id]);
    return json({ success: true, message: 'Mata pelajaran berhasil dihapus' });
  } catch (error) {
    console.error('Delete subject error:', error);
    return json({ error: 'Gagal menghapus mata pelajaran' }, { status: 500 });
  }
}
